/******************************************************************************

Image I/O and Image processing code 

Copyright 2000 by the University of Waterloo
All rights reserved.
   
Developed by: Richard Mann, Department of Computer Science

******************************************************************************/
#define min(A,B) ((A)<(B)?(A):(B))
#define max(A,B) ((A)>(B)?(A):(B))
#define abs(A) ((A)>(0)?(A):(-A))
#define sign(A,B) ((B)>=(0)?(A):(-(A)))
#define sqr(A) ((A)*(A))
#define round(A) (floor(0.5+(A)))
#ifndef PI
  #define PI M_PI
#endif

/* image accessor: image(x,y) */
#define I(imageP, nx, ny, x, y) imageP[x+y*nx]

/* maximum # of image modes (excluding outlier) */
#define MAXMODES 4

void error(char *s1, char *s2);

float interp2(float *imageP, int nx, int ny, float x, float y);
void filter_image_x(float *imageP, int nx, int ny, float *filtP, int nfilt);
void filter_image_y(float *imageP, int nx, int ny, float *filtP, int nfilt);
void diff_image_x(float *imageP, int nx, int ny);
void diff_image_y(float *imageP, int nx, int ny);
void smooth_image(float *imageP, int nx, int ny, float sigma);
float *make_image(int nx, int ny);
void *free_image(float *imageP);
float *copy_image(float *imageP, int nx, int ny);
float *read_pgm_image(char *filenameP, int *nxP, int *nyP);
int write_pgm_image(char *filenameP, float *imageP, int nx, int ny, char *blurb);
float image_max(float *imageP, int nx, int ny);
float image_min(float *imageP, int nx, int ny);
void scale_image(float *imageP, int nx, int ny, float scale);
float *add_images(float *image1P, float *image2P, int nx, int ny);
float *subtract_images(float *image1P, float *image2P, int nx, int ny);
float *multiply_images(float *image1P, float *image2P, int nx, int ny);
void test_richard();
