/* -*- C++ -*- */
// this is the library of silly functions we will use to compute disparity and
// whatnot


// target class
class target {
public:
  // target number
  int n;  
  // target centroid
  int cx,cy;
  // target bounding rectangle
  int x1,x2,y1,y2;
  // target velocity
  int vx,vy;
  // target reliability
  int reliability;
};


void rotate(float *IM, float *RIM, int xsize, int ysize,
	    int cx, int cy, float theta);
void translate(float *im1, float *im2, int xsize, int ysize, int tx, int ty);
void align(float *im1, float *im2, int xsize, int ysize,
	   int x, int y, int xrange, int yrange,
	   float theta_range, int theta_steps, int tx_range, int ty_range,
	   float &theta, int &tx, int &ty);
void compute_disparity(float *im1, float *im2, int *xmap, int *ymap,
		       int xsize, int ysize, int XWIN, int YWIN, int D);
void find_similar_blobs(int *xmap, int *ymap, int *nxmap, int *nymap,
			int xsize, int ysize,
			int dx, int dy, int thresh, int below);
void mask_under_thresh(float *im, int *xmap, int *ymap, int xsize, int ysize, 
		       int thresh);
void mask_over_thresh(float *im, int *xmap, int *ymap, int xsize, int ysize, 
		      int thresh);
int designate_targets(int *xmap, int *ymap, int xsize, int ysize, int drange, 
		      float prop, int thresh, target tlist[], int maxtarg);
void save_disp(char *filename, int *dx, int *dy, int x, int y);
void load_disp(char *filename, int *dx, int *dy);
int build_group(int *dx, int *dy, int *mask, int sizex, int
		sizey, int x, int y, int thresh,int col);
void compute_xy_histogram(int *mask, int *xhist, int *yhist, int xsize, int ysize);
void find_bounding_rect(int *xhist, int *yhist, int xsize, int ysize, float P,
			int &x1, int &x2, int &y1, int &y2, int &cx, int &cy);
